@ECHO OFF
SET NAME=SA45AR13.BIN
IF "%1"=="ME" GOTO AMT
IF "%1"=="me" GOTO AMT
GOTO BIOS

:BIOS
rem -------------------- Flash BIOS only -------------------------------------
echo.
echo *************************** Notice!! ********************************
echo             Start updating BIOS without touching ME firmware
echo *********************************************************************
echo.
pause
xtbios %NAME% bios.rom
rem fpt -bios -f bios.rom
afudos BIOS.rom /p /b /n /x
IF ERRORLEVEL 405 GOTO FAILED
IF ERRORLEVEL 1 GOTO ERROR
echo ***************************************************
echo            Flash process completed.
echo            Please restart system.
echo ***************************************************
GOTO END


rem -------------------- Flash BIOS and AMT/ME -------------------------------
:AMT
echo.
echo *************************** Notice!! ********************************
echo             Start updating both BIOS and ME firmware.
echo
echo                      Before processing,
echo (1) Go into MEBX menu by pressing 'Ctrl+P' during POST,
echo     and disable ME manually in ME configurations.
echo (2) Otherwise, this utility will disable ME automatically and reboot,
echo     user MUST re-execute the batch again.
echo
echo                   Any AMT/ME data will be lost.
echo *********************************************************************
echo.
pause
if exist temp.eep del bios.rom
fpt -gbe -d temp.eep -y
IF ERRORLEVEL 1 GOTO FAILED
fpt -f %NAME% -y
IF ERRORLEVEL 405 GOTO FAILED
IF ERRORLEVEL 1 GOTO ERROR
fpt -gbe -f temp.eep
IF ERRORLEVEL 1 GOTO ERROR
echo **********************************************************
echo                Flash process completed.
echo Please turn power supply off and on for restarting system.
echo **********************************************************
GOTO END


rem -------------------- Flash Exit -------------------------------------------
:FAILED
echo ***************************************************
echo                 Update failed
echo ***************************************************
GOTO END

:ERROR
echo ***************************************************
echo  Data error detected. Please re-execute this batch
echo ***************************************************
GOTO END

:END
